<?php
/*--------------------------------------------------------------------
 ServiceProvider.php 2020-2-19
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\SellingUnit\Unit;

use Gambio\Shop\SellingUnit\Unit\Factories\Interfaces\SellingUnitIdFactoryInterface;
use Gambio\Shop\SellingUnit\Unit\Factories\SellingUnitIdFactory;
use League\Container\Container;
use League\Container\ServiceProvider\AbstractServiceProvider;
use League\Container\ServiceProvider\BootableServiceProviderInterface;

/**
 * Class ServiceProvider
 * @package Gambio\Shop\Product\Name
 * @property-read Container $container
 */
class ServiceProvider extends AbstractServiceProvider implements BootableServiceProviderInterface
{
    /**
     * @var string[]
     */
    protected $provides = [
        SellingUnitIdFactoryInterface::class
    ];
    
    
    /**
     * @inheritDoc
     */
    public function register(): void
    {
        $this->container->share(SellingUnitIdFactoryInterface::class, SellingUnitIdFactory::class);
    }
    
    
    /**
     * @inheritDoc
     */
    public function boot(): void
    {
    
    }
}